var statusBar = document.createElement('div');
statusBar.className = 'statusBar'
statusBar.style.position = 'fixed';
statusBar.style.bottom = '0';
statusBar.style.left = '0';
statusBar.style.backgroundColor = 'rgba(0, 0, 0, 0.7)';
statusBar.style.color = 'white';
statusBar.style.padding = '5px';
statusBar.style.display = 'none';
statusBar.style.zIndex = '10000000';
document.body.appendChild(statusBar);

function addListenersToLink(link) {
  link.addEventListener('mouseover', function () {
      if (enableUrlPreview && enableUrlPreview == true) {
          statusBar.innerText = this.href;
          statusBar.style.display = 'block';
      }
  });
  link.addEventListener('mouseout', function () {
    statusBar.style.display = 'none';
  });
}

var elements = document.getElementsByTagName('a');
for (var i = 0; i < elements.length; i++) {
  addListenersToLink(elements[i]);
}

var observer = new MutationObserver(function (mutations) {
  mutations.forEach(function (mutation) {
    if (mutation.type !== 'childList') {
      return;
    }
    mutation.addedNodes.forEach(function (node) {
      if (node.nodeType !== Node.ELEMENT_NODE) {
        return;
      }
      var links = node.getElementsByTagName('a');
      for (var i = 0; i < links.length; i++) {
        addListenersToLink(links[i]);
      }
    });
  });
});

observer.observe(document.body, { childList: true, subtree: true });
