window.addEventListener("keydown", checkKey, false);

function checkKey(evt) {
    if (com_bzg_unite_del_key_disable == false) {
        return true;
    }

    evt = evt || window.event;
    const key = evt.key;
    var keyCode = evt.keyCode || evt.charCode;

    // Detect specific sites
    var isCopilotSite = window.location.hostname.includes("copilot.microsoft");
    var isRedditSite = window.location.hostname.includes("reddit");

    // General form elements (applies to all sites)
    const formElementsTags = ['INPUT', 'TEXTAREA', 'input', 'textarea'];
    const formElementsTypes = ['text', 'search', 'email', 'number', 'password', 'tel', 'url'];
    const formElementsIDs = ['username', 'userid', 'password', 'login'];

    // Add Reddit-specific form elements
    if (isRedditSite) {
        formElementsTags.push('reddit-search-large');
    }

    // Handle backspace, delete, and Copilot-specific keycode 51
    if (key === "Backspace" || key === "Delete" || keyCode == 8 || keyCode == 46 || (isCopilotSite && keyCode == 51)) {
        
        var tagName = evt.target.tagName;
        if (tagName) {
            var tagNameLower = tagName.toLowerCase();
            var tagNameFound = formElementsTags.some(tag => tagNameLower.includes(tag.toLowerCase()));
            if (tagNameFound) {
                return true;  // Allow backspace/delete in specific elements
            }
        }

        var type = evt.target.type;
        if (type && formElementsTypes.includes(type)) {
            return true;  // Allow backspace/delete in input types
        }

        var elementID = evt.target.id;
        if (elementID && formElementsIDs.includes(elementID)) {
            return true;  // Allow backspace/delete in specific IDs
        }

        var contentEditable = evt.target.contentEditable;
        if (contentEditable && (contentEditable === "true" || contentEditable.includes("text"))) {
            return true;  // Allow backspace/delete in content-editable elements
        }

        var role = evt.target.role;
        if (role && ['text', 'search', 'box'].includes(role.toLowerCase())) {
            return true;  // Allow backspace/delete in specific roles
        }

        var className = evt.target.className;
        if (className) {
            var classNameLower = className.toLowerCase();
            const formElementsClassNames = ['input', 'text', 'edit', 'cell', 'password', 'search', 'textarea', 'text-input', 'text-area', 'cib-serp-main', 'editor'];

            if (isRedditSite) {
                formElementsClassNames.push('reddit-search-large');  // Handle Reddit-specific elements
            }

            var classNameFound = formElementsClassNames.some(classNameTemp => classNameLower.includes(classNameTemp));
            if (classNameFound) {
                return true;  // Allow backspace/delete for specific classes
            }
        }

        // Prevent default action if no match found (site-specific actions)
        evt.preventDefault();
        evt.stopPropagation();
    } else {
        // Ensure # key and general shortcuts work on all sites
        return true;
    }
}
